#include <bits/stdc++.h>

using namespace std;

#define ll long long
const int INF=1e9;
const ll LINF=1e18,MOD=1e9+7;
#define fi first
#define se second
#define pii pair<int,int>
#define mid ((l+r)/2)
#define sz(a) (int((a).size()))
#define all(a) a.begin(),a.end()
#define endl "\n"
#define pb push_back

void PRINT(int x) {cerr << x;}
void PRINT(ll x) {cerr << x;}
void PRINT(double x) {cerr << x;}
void PRINT(char x) {cerr << '\'' << x << '\'';}
void PRINT(string x) {cerr << '\"' << x << '\"';}
void PRINT(bool x) {cerr << (x ? "true" : "false");}

template<typename T,typename V>
void PRINT(pair<T,V>& x){
    cerr<<"{";
    PRINT(x.fi);
    cerr<<",";
    PRINT(x.se);
    cerr<<"}";
}
template<typename T>
void PRINT(T &x){
    int id=0;
    cerr<<"{";
    for(auto _i:x){
        cerr<<(id++ ? "," : "");
        PRINT(_i);
    }
    cerr<<"}";
}
void _PRINT(){
    cerr<<"]\n";
}
template<typename Head,typename... Tail>
void _PRINT(Head h,Tail... t){
    PRINT(h);
    if(sizeof...(t)) cerr<<", ";
    _PRINT(t...);
}

#define Debug(x...) cerr<<"["<<#x<<"]=["; _PRINT(x)

const int mxN=2e5;
int N;

ll A[mxN+1],C[mxN+1],B[mxN+1];
ll seg[4*mxN+1];
bool lz[4*mxN+1];

void Init(int node,int l,int r){
    if(l==r){
        seg[node]=B[l];
        return;
    }
    Init(2*node,l,mid); Init(2*node+1,mid+1,r);
    seg[node]=seg[2*node]+seg[2*node+1];
}

void Propagate(int node,int l,int r){
    if(lz[node]){
        seg[node]=0;
        if(l<r){
            lz[2*node]=true;
            lz[2*node+1]=true;
        }
        lz[node]=false;
    }
}

void Update(int node,int l,int r,int idx,ll x){
    Propagate(node,l,r);
    if(l==r){
        seg[node]-=x;
        return;
    }
    if(idx<=mid) Update(2*node,l,mid,idx,x);
    else Update(2*node+1,mid+1,r,idx,x);
    seg[node]=seg[2*node]+seg[2*node+1];
}

void Update1(int node,int l,int r,int L,int R){
    if(l>r) return;
    Propagate(node,l,r);
    if(l>R || r<L) return;
    if(L<=l && r<=R){
        lz[node]=true;
        Propagate(node,l,r);
        return;
    }
    Update1(2*node,l,mid,L,R); Update1(2*node+1,mid+1,r,L,R);
    seg[node]=seg[2*node]+seg[2*node+1];
}

int Walk(int node,int l,int r,ll x){
    if(seg[node]<x) return N+1;
    if(l==r) return l;
    Propagate(node,l,r); Propagate(2*node,l,r); Propagate(2*node+1,l,r);
    if(seg[2*node]>=x) return Walk(2*node,l,mid,x);
    else return Walk(2*node+1,mid+1,r,x-seg[2*node]);
}

ll Query(int node,int l,int r,int L,int R){
    if(l>r) return 0;
    Propagate(node,l,r);
    if(l>R || r<L) return 0;
    if(L<=l && r<=R) return seg[node];
    return Query(2*node,l,mid,L,R)+Query(2*node+1,mid+1,r,L,R);
}

void Solve(){
    cin>>N;
    for(int i=1;i<=N;i++) cin>>A[i];
    for(int i=1;i<=N;i++) cin>>C[i];
    for(int i=1;i<=N;i++) B[i]=C[i]-A[i];
    Init(1,1,N);
    int Q; cin>>Q;
    while(Q--){
        int id,x; cin>>id>>x;
        ll pref=(id>1 ? Query(1,1,N,1,id-1) : 0);
        int R=Walk(1,1,N,pref+x);
        ll ost=x;
        if(R!=id){
            ost-=Query(1,1,N,id,R-1);
            Update1(1,1,N,id,R-1);
        }
        if(R<=N) Update(1,1,N,R,ost);
    }
    for(int i=1;i<=N;i++){
        cout<<C[i]-Query(1,1,N,i,i)<<" ";
    }
    cout<<endl;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    int t;
    t=1;
    //cin>>t;
    while(t--){
        Solve();
    }
    return 0;
}